/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrHttpResponse;
import com.ibm.hwmca.base.rsf.requests.SdrRequestBody;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.PIProblemDataConstants;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ESARsfResultProcessor
implements RsfResultProcessor,
ServiceAgentAttr,
PIProblemDataConstants {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[ESARsfResultProcessor] ";

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] rsfRequestCompleted");
        String status = "ESA.status.success";
        LocalizableText statusDetails = result.getStatusMessage();
        String[] textmsg = null;
        String[] return_code = null;
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, null, null, null, null, null);
        theLog.add((byte)3, request.getId());
        block = (byte)(block + 1);
        theLog.add(block, result);
        int statusCode = result.getStatusCode();
        if (statusCode == 1) {
            RsfResultDetails details = result.getDetails();
            if (details != null) {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got details");
                ArrayList sdrResponses = (ArrayList)details.getAttribute("Sdr Responses");
                if (sdrResponses != null) {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got sdrResponses " + sdrResponses.size());
                    textmsg = new String[sdrResponses.size()];
                    return_code = new String[sdrResponses.size()];
                    int i = 0;
                    while (i < sdrResponses.size()) {
                        SdrHttpResponse httpResponse = (SdrHttpResponse)sdrResponses.get(i);
                        SdrHttpRequest httpRB = httpResponse.getRequest();
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getHttpRc());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getHttpRcText());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getResponseRc());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getXmlRc());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getXmlResponse());
                        statusDetails = result.getReasonMessage();
                        String xmlResponse = httpResponse.getXmlResponse();
                        if (xmlResponse != null && xmlResponse.length() > 0) {
                            String request_id;
                            String reason_code;
                            block = (byte)(block + 1);
                            theLog.add(block, xmlResponse);
                            HashMap map = new HashMap();
                            ServiceAgentUtils.processSdrReturn(xmlResponse, map);
                            String return_text = (String)map.get("return-text");
                            if (return_text != null) {
                                textmsg[i] = return_text;
                            }
                            return_code[i] = (String)map.get("return-code");
                            if (return_code[i] != null) {
                                textmsg[i] = textmsg[i] + " ReturnCode=" + return_code[i];
                            }
                            if ((reason_code = (String)map.get("reason-code")) != null) {
                                textmsg[i] = textmsg[i] + " ReasonCode=" + reason_code;
                            }
                            if ((request_id = (String)map.get("request-id")) != null) {
                                textmsg[i] = textmsg[i] + " ReqID=" + request_id;
                            }
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] SDR textmsg: " + textmsg);
                        } else {
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] xmlResponse not set");
                        }
                        ++i;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] sdrResponses was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] details was null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] StatusCode not OK: " + statusCode);
        }
        if (return_code != null) {
            int i = 0;
            while (i < return_code.length) {
                if (!return_code[i].equals("100")) {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] return_code non_success: " + (String)return_code[i]);
                    status = "ESA.status.failed";
                    break;
                }
                ++i;
            }
        } else {
            status = "ESA.status.failed";
        }
        SdrRequestBody sdrRB = (SdrRequestBody)request.getBody();
        ServiceAgentAttr.ESAsdrRequest sdrRequest = (ServiceAgentAttr.ESAsdrRequest)sdrRB.getUserAttachment();
        if (sdrRequest != null) {
            String from;
            String failingmtms;
            String failingsystem;
            String problem;
            String pmh;
            block67: {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] requestType: " + sdrRequest.requestType);
                pmh = "";
                problem = "";
                failingsystem = "";
                failingmtms = "";
                from = "";
                NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
                    from = from + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
                }
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] from: " + from);
                if (sdrRequest.problemUUID != null) {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got problemUUID: " + sdrRequest.problemUUID);
                    try {
                        ProblemManager pm = ProblemManager.getProblemManager();
                        PIProblem theProblem = (PIProblem)pm.getProblem(sdrRequest.problemUUID);
                        if (theProblem == null) break block67;
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got theProblem");
                        problem = String.valueOf(theProblem.getProblemNumber());
                        pmh = theProblem.getPMH();
                        if (theProblem.getReportingRemoteMachineSystem() != null && theProblem.getReportingRemoteMachineSystem().getMOSystemName() != null) {
                            failingsystem = theProblem.getReportingRemoteMachineSystem().getMOSystemName();
                        }
                        if (networkInfo != null && failingsystem.length() == 0) {
                            failingsystem = networkInfo.getComputerName();
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] failingsystem: " + failingsystem);
                        if (theProblem.getFailingSystem().getMTMS() != null) {
                            failingmtms = theProblem.getFailingSystem().getMTMS();
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] failingmtms: " + failingmtms);
                        theProblem.getProblemData().add("pdc_ESA_STATUS", new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", status));
                        theProblem.getProblemData().add("pdc_ESA_SDRSTATUS", statusDetails);
                        int rcCount = 0;
                        if (sdrRequest.sdrFiles != null) {
                            Iterator kk = sdrRequest.sdrFiles.entrySet().iterator();
                            while (kk.hasNext()) {
                                Map.Entry e = kk.next();
                                String fileKey = (String)e.getKey();
                                if (fileKey.equals("EED") && return_code != null && rcCount < return_code.length && return_code[rcCount].equals("100")) {
                                    ServiceAgentAttr.ESAsdrFileInfo sdrFileInfo = (ServiceAgentAttr.ESAsdrFileInfo)e.getValue();
                                    String fileLocation = sdrFileInfo.fileName;
                                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] working with fileLocation: " + fileLocation);
                                    List dList = theProblem.getProblemDataSet();
                                    if (dList != null) {
                                        int i = 0;
                                        while (i < dList.size()) {
                                            ProblemDataDescriptor dd = (ProblemDataDescriptor)dList.get(i);
                                            if (dd != null) {
                                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] working with name: " + dd.getName());
                                                if (fileLocation.endsWith(dd.getName())) {
                                                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] setCalledHome for: " + dd.getFileLocation());
                                                    dd.setCalledHome(true);
                                                    break;
                                                }
                                            } else {
                                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] dd was null");
                                            }
                                            ++i;
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] dList was null");
                                    }
                                }
                                ++rcCount;
                            }
                        }
                        try {
                            pm.changed(theProblem);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] pm.changed exception");
                            Trace.trace(TRACE_MASKF, e);
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] problem manager exception");
                        Trace.trace(TRACE_MASKF, e);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] problemUUID not set");
                }
            }
            String subject = "";
            String message = "";
            if (sdrRequest.requestType.equals("Problem_EED")) {
                theLog.setEventName("SaEEDRes");
                subject = "Transmission of Problem Information";
                message = status.equals("ESA.status.success") ? "Successfully transmitted problem information." : "Unsuccessfully transmitted problem information.";
            } else if (sdrRequest.requestType.equals("Authorization")) {
                theLog.setEventName("SaAuthRes");
                String authorizationID = sdrRequest.authorizationID;
                if (authorizationID == null || authorizationID.length() <= 0) {
                    authorizationID = " ";
                }
                subject = "Web Authorization";
                message = status.equals("ESA.status.success") ? "Successfully issued authorization request for the following ID(s):\n" + authorizationID : "Unsuccessfully issued authorization request for the following ID(s):\n" + authorizationID;
            } else if (sdrRequest.requestType.equals("Xmit_Immediate")) {
                theLog.setEventName("SaXmtImmRes");
                subject = "Immediate Transmission of Service Information";
                message = status.equals("ESA.status.success") ? "Successfully transmitted service information." : "Unsuccessfully transmitted service information.";
            } else if (sdrRequest.requestType.equals("Xmit_Scheduled")) {
                theLog.setEventName("SaXmtSchRes");
                subject = "Scheduled Transmission of Service Information";
                message = status.equals("ESA.status.success") ? "Successfully transmitted service information." : "Unsuccessfully transmitted service information.";
            } else if (sdrRequest.requestType.equals("Xmit_VPD")) {
                theLog.setEventName("SaVPDRes");
                subject = "End of Call Transmission of Service Information";
                message = status.equals("ESA.status.success") ? "Successfully transmitted service information." : "Unsuccessfully transmitted service information.";
            } else if (sdrRequest.requestType.equals("Dump_EED")) {
                theLog.setEventName("SaEEDRes");
                subject = "Transmission of Dump Information";
                message = status.equals("ESA.status.success") ? "Successfully transmitted dump information." : "Unsuccessfully transmitted dump information.";
            } else {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] invalid requestType: " + sdrRequest.requestType);
            }
            if (subject.length() > 0) {
                if (sdrRequest.sdrFiles != null) {
                    message = message + "\n";
                    Iterator i = sdrRequest.sdrFiles.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        ServiceAgentAttr.ESAsdrFileInfo sdrFileInfo = (ServiceAgentAttr.ESAsdrFileInfo)e.getValue();
                        message = message + "\n" + (String)e.getKey() + ": " + sdrFileInfo.fileName;
                        if (sdrFileInfo.remove) {
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] remove fileName: " + sdrFileInfo.fileName);
                            try {
                                File remFile = new File(sdrFileInfo.fileName);
                                if (remFile != null) {
                                    remFile.delete();
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] remFile was null");
                            }
                            catch (Exception reme) {
                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] delete file exception");
                                Trace.trace(TRACE_MASKF, reme);
                            }
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] do not remove fileName: " + sdrFileInfo.fileName);
                    }
                    message = message + "\n";
                }
                if (failingsystem.length() > 0) {
                    message = message + "\nReporting System: " + failingsystem;
                }
                if (failingmtms.length() > 0) {
                    message = message + "\nMachine type-model/serial: " + failingmtms;
                }
                if (problem.length() > 0) {
                    message = message + "\nProblem number: " + problem;
                }
                if (pmh != null && pmh.length() > 0) {
                    message = message + "\nPMR number: " + pmh;
                }
                message = message + "\n" + statusDetails.toString(Locale.US);
                if (textmsg != null) {
                    message = message + "\nDetails:";
                    int i = 0;
                    while (i < textmsg.length) {
                        message = message + "\n" + textmsg[i];
                        ++i;
                    }
                }
                if (ServiceAgentUtils.getEmailSetting()) {
                    int rc = ServiceAgentUtils.ESASendEmailMsg("N", new LocalizableText(subject + " from " + from), new LocalizableText(message));
                } else {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] email not enabled");
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] sdrRequest not set");
        }
        theLog.log();
    }
}

